function [mStatesPriorEn,mStatesExcluded,mOutputs]=sodaPropStates(sodaPar,iIter,mConstants,...
    mStatesPriorEn,mStatesPostEn,mPars,mStatesExcluded,mOutputs)

nMembers = sodaPar.nEnsembleMembers;
nStates = sodaPar.nStates;
nOutputs = sodaPar.nOutputs;

for iMember = 1:nMembers

    for iState=1:nStates
        mStatesIn{iState,1} = sodaPar.stateNames{iState};
        mStatesIn{iState,2} = mStatesPostEn(iIter-1,iState,iMember);
    end

    mTime = {sodaPar.iterator{1,1},sodaPar.iterator{1,2}(iIter)};
    
    
    evalStr = ['[mStatesOut,mStatesExcluded{iMember},mOutputsOut] = ',sodaPar.modelName,...
                    '(mConstants,mStatesIn,mStatesExcluded{iMember},mPars,mTime);'];
    
    eval(evalStr)

    
    for iState=1:nStates
        mStatesPriorEn(iIter,iState,iMember) = mStatesOut{iState,2};
    end
    
    for iOutput = 1:nOutputs
        mOutputs(iIter,iOutput,iMember) = mOutputsOut{iOutput,2};
    end
    
end
